# Court Booking Solution — Action Plan
**Prepared by:** ARIA  
**Date:** 2026-03-04  
**Current Phase:** Discovery → Design Transition  
**Owner:** Drew Oplas (drew.oplas@symph.co)  
**Product Slug:** `court-booking`

---

## Executive Summary

The Court Booking Solution is a two-sided marketplace platform targeting the indoor sports court booking space in the Philippines — starting with badminton and pickleball in Metro Manila. Discovery phase is **complete** with an exceptional opportunity score of **4.60/5.00**. The design phase has been initiated but is **stalled at preview stage**, awaiting human approval before full brand and screen development can proceed.

The core insight: **90% of courts still book via Messenger/phone.** No dominant platform exists. This is a greenfield category with validated demand on both sides. The recommended path is a **Lean MVP → Standard phased rollout**, launching in 6-8 weeks for the MVP.

---

## Where We Are Now

| Phase | Status | Notes |
|-------|--------|-------|
| **Discovery** | ✅ Complete | PRD, user stories, competitor analysis, GTM strategy, pitch deck, opportunity score — all done |
| **Design** | 🟡 In Progress (Stalled) | Brand preview generated (logo, colors, 3 sample screens). `awaiting_approval: true` — needs Drew's sign-off |
| **Build** | ⏳ Not Started | Blocked on design approval |
| **Market** | ⏳ Not Started | — |
| **Sell** | ⏳ Not Started | — |

**Immediate blocker:** Design phase preview is complete but no approval has been recorded. Drew needs to review the preview assets and give the go-ahead to proceed to full design (brand guidelines + all screens).

---

## Phase 1 — Unblock Design (This Week)

### 1.1 — Review & Approve Design Preview

**Owner:** Drew  
**Deadline:** ASAP (blocking everything downstream)

Design preview is ready at `/home/aria/products/court-booking/design/assets/`:

| Asset | File | Status |
|-------|------|--------|
| Logo | `logo-courtbook.png` | ✅ Ready |
| Home / Discover Screen | `screen-01-home.png` | ✅ Ready |
| Court Availability Screen | `screen-02-availability.png` | ✅ Ready |
| Booking Confirmation Screen | `screen-03-confirmation.png` | ✅ Ready |

**Brand palette proposed:**
- Primary: Court Blue `#0EA5E9`
- Secondary: Midnight Navy `#0F172A`
- Accent: Rally Green `#84CC16`
- Fonts: Plus Jakarta Sans (headings) + Inter (body)

**Action required:** Review the logo + 3 sample screens in Symphony. Approve (or provide feedback) so the design agent can proceed to Stage 2 — full brand guidelines + all app screens.

---

### 1.2 — Answer Open PRD Questions

Before design goes deep into flows, these decisions must be locked in:

| # | Question | Impact |
|---|----------|--------|
| 1 | **Cancellation policy** — standard 24h refund or venue-controlled? | Booking flow complexity |
| 2 | **Payment flow** — pre-pay 100% or deposit (50%) + balance on-site? | Revenue collection + SymphPay config |
| 3 | **No-show penalty** — charge fee? Auto-ban? | Venue trust & retention |
| 4 | **Venue onboarding** — fully self-serve or Symph-assisted setup? | GTM ops |
| 5 | **Commission split** — 5% player + 7% venue = 12% total? | Revenue model |
| 6 | **Slot duration** — 1-hour minimum or 30-min slots? | Calendar grid design |

---

## Phase 2 — Complete Design (Weeks 1–3)

Once preview is approved, design agent proceeds to Stage 2.

### 2.1 — Brand Guidelines

Full doc covering: logo usage, color system, typography scale, iconography, spacing/grid, component visual system.

### 2.2 — Player App Screens (Mobile Web)

| Screen Group | Screens |
|--------------|---------|
| Onboarding | Splash, Sign Up, Log In, Email Verification |
| Discovery | Home/Browse, Search + Filters, Venue Detail |
| Booking | Availability Grid, Court Selection, Booking Summary, Payment, Confirmation |
| My Bookings | Upcoming, Past, Booking Detail (QR), Cancel Flow |
| Account | Profile, Settings, Notifications |

### 2.3 — Venue Dashboard Screens (Web)

| Screen Group | Screens |
|--------------|---------|
| Onboarding | Venue Setup Wizard |
| Calendar | Schedule View, Block/Unblock Slots |
| Bookings | Booking List, Detail, Check-in (QR Scanner) |
| Settings | Venue Profile, Courts, Pricing, Hours, Cancellation Policy |
| Payouts | Earnings Summary, Transaction History |
| Analytics | Bookings, Utilization, Revenue dashboard |

---

## Phase 3 — Build: Lean MVP (Weeks 4–12)

**Budget:** ₱400-600K | **Team:** 2 devs + 1 designer | **Timeline:** 6-8 weeks

### 3.1 — Technical Stack

| Layer | Technology |
|-------|-----------|
| Frontend | Next.js 15, Tailwind v4, shadcn/ui |
| Backend | Firebase (Firestore, Auth, Functions) |
| Payments | SymphPay (GCash, PayMaya, card) |
| Notifications | Twilio (SMS) + SendGrid (email) |
| Hosting (Dev) | Caddy — `court-booking.dev.apps.symph.co` |
| Hosting (Prod) | Cloud Run, GCP project `theagency-ai` |
| Firebase Project | `symph-court-booking` (to be created) |

### 3.2 — Infrastructure Setup (Before Build)

- [ ] Create Firebase project: `symph-court-booking` under Symph Products folder
- [ ] Link billing account: `01F3D7-6E8F01-1E2163`
- [ ] Set up Firestore namespaces: `dev_*`, `staging_*`, `prod_*`
- [ ] Enable Firebase Auth (Email/Password + Google OAuth)
- [ ] Create GCS bucket: `gs://symph-court-booking`
- [ ] Create `CLAUDE.md` in product repo with full design context
- [ ] Set up Caddy dev domain
- [ ] Create GitHub repo: `SymphonyAgents/court-booking` + add symphony-devs team

### 3.3 — Sprint Plan

**Sprint 1 (Weeks 4–5) — Core Infrastructure**
- Firebase setup (Auth, Firestore schema, Functions scaffold)
- Next.js app from agency-app-starter
- Caddy dev domain live
- Auth flows (sign up, log in, email verify)
- Venue data model + seed data

**Sprint 2 (Weeks 6–7) — Booking Core**
- Venue discovery (list view + filters)
- Venue detail page
- Real-time availability grid (Firestore listeners)
- Full booking flow → SymphPay → confirmation + QR code

**Sprint 3 (Weeks 8–9) — Venue Dashboard**
- Venue owner login + dashboard shell
- Calendar (view/block/unblock slots)
- Manual booking creation (walk-ins)
- Booking management (view, cancel, QR check-in)
- Venue settings (profile, courts, pricing, hours)

**Sprint 4 (Weeks 10–11) — Payouts + Notifications**
- Payout tracking (earnings view, transaction history)
- SymphPay webhook handling (confirmation, refunds)
- Email (SendGrid): booking confirmation, cancellation
- SMS (Twilio): confirmation, 24h reminder
- No-show tracking (manual flag)

**Sprint 5 (Week 12) — QA + Soft Launch**
- End-to-end booking flow testing
- Mobile responsiveness pass
- ReadStreak QA protocol (5 rounds, stale build check)
- Soft launch on dev domain

### 3.4 — Firestore Data Model

```
venues/{venueId}
  name, slug, location (geopoint), address, city
  sport[] (badminton, pickleball)
  courts[]: { id, name, pricePerHour }
  operatingHours: { open, close, days[] }
  cancellationPolicy: { hoursBeforeRefund, refundPercent }
  photos[], amenities[], status

bookings/{bookingId}
  venueId, courtId, playerId
  date, startTime, endTime
  status (pending | confirmed | cancelled | no-show)
  paymentId, totalAmount, feePaid
  qrCode, checkInAt

players/{playerId}
  name, email, phone
  bookingHistory[]

payouts/{payoutId}
  venueId, amount, status
  periodStart, periodEnd
  transactions[]
```

---

## Phase 4 — Go-to-Market (Weeks 10–14, parallel to build)

### 4.1 — Venue Recruitment (Supply-First)

**Target:** 5-10 anchor venues for invite-only beta  
**Venue CAC target:** ₱15,000 per venue

**Priority zones:**
1. Quezon City (200+ courts — highest density)
2. Makati CBD (corporate players, premium WTP)
3. BGC Taguig (expats, premium)
4. Pasig/Mandaluyong (growing middle-class)
5. Alabang (south corridor hub)

**Ideal venue profile:**
- 4-6 courts, owner-operated
- Currently booking via Messenger/phone
- 65%+ utilization (demand exists, system is missing)

**Outreach approach:**
- Direct field visit + live demo (not cold email)
- Pitch: "Free court management system. You only pay when we bring you bookings."
- Beta: Symph-assisted onboarding (not self-serve)

### 4.2 — Player Acquisition

**Beta (Months 1-2):** Seed from venues — QR codes at courts, venue social media posts, first booking free of platform fee

**Public Launch (Month 3):**
- Facebook/Instagram geo-targeted ads (NCR sports enthusiasts) — ₱50K/month
- Influencer partnerships (badminton/pickleball personalities) — ₱20K/month
- Google Ads (court booking keywords) — ₱30K/month
- Referral: ₱100 credit per successful referral

**Player CAC target:** ₱150

### 4.3 — Marketing Assets Needed

- [ ] App landing page (courtbook.ph or equivalent)
- [ ] Venue sales deck (PDF for field visits)
- [ ] 60-second demo video (booking flow screen recording)
- [ ] Social media brand launch kit (Instagram + Facebook)
- [ ] QR code sticker template for venue check-in desks

### 4.4 — Pricing Model (to confirm)

| Stream | Rate |
|--------|------|
| Player convenience fee | ₱25–50 per booking |
| Venue commission | 8% of booking value |
| SymphPay processing | ~2.9% |
| Venue premium plan (post-MVP) | ₱8,000/month |

---

## Phase 5 — Pilot Validation (Months 3–4)

### MVP Go/No-Go Metrics

| Metric | Target | Signal |
|--------|--------|--------|
| Booking completion rate | ≥60% | UX is working |
| 30-day player retention | ≥40% | Habit forming |
| Bookings per player/month | ≥3 | Platform is sticky |
| No-show rate | ≤10% | Deposit system working |
| Venue utilization lift | +15% | Platform is adding value |
| Time to complete booking | <2 min | Core UX promise delivered |

### Ongoing User Research

- [ ] Interview 10 venue owners before build
- [ ] Survey 50 active players before build
- [ ] Usability test booking flow prototype (5 users)
- [ ] Monthly 15-min calls with 3 anchor venues during beta

---

## Phase 6 — Scale to Standard (Months 5–8, if metrics hit)

**Added features:**
- Find-a-Player (post/browse open game slots)
- Player reviews & ratings
- Player profiles (skill level, play history)
- Group booking (invite friends, split payment)
- Off-peak dynamic pricing
- Enhanced venue analytics (peak heatmap, revenue by court)
- Promo codes

**Scale targets:**
- 20-30 venue partners (NCR)
- 5,000+ active players
- ₱750K monthly GMV
- ₱110K monthly revenue

---

## Risk Register

| Risk | Impact | Prob | Mitigation |
|------|--------|------|------------|
| Venues resist leaving Messenger | High | Med | Free onboarding, zero cost until bookings arrive |
| Players don't see value vs. DMing venue | High | Med | Speed demo — "60 seconds vs 15 minutes" |
| Payment fraud | Med | Low | SymphPay fraud detection, mobile verify |
| Double bookings (sync issues) | High | Low | Firestore transactions + real-time listeners |
| Competitor enters market | Med | Low | Lock in anchor venues fast, build community moat |
| Venue no-shows hurting trust | High | Med | 50% deposit required at booking |
| Regulatory / BSP compliance | Med | Low | SymphPay handles compliance |

---

## Immediate Next Actions

| Priority | Action | Owner | Deadline |
|----------|--------|-------|----------|
| 🔴 P0 | Approve design preview in Symphony (logo + 3 screens) | Drew | This week |
| 🔴 P0 | Answer 6 open PRD decisions (cancellation, payment flow, commission, etc.) | Drew | This week |
| 🟠 P1 | Full design phase — brand guidelines + all screens | Design Agent | 2 weeks after approval |
| 🟠 P1 | Create Firebase project `symph-court-booking` | ARIA | After design approval |
| 🟠 P1 | Create GitHub repo + CLAUDE.md with design context | ARIA | Before build starts |
| 🟡 P2 | Start venue prospect list (10 NCR targets) | Drew / Sales | Week 2 |
| 🟡 P2 | Register app domain (courtbook.ph or similar) | Drew | Week 2 |
| 🟡 P2 | Finalize commission structure | Drew | Week 2 |
| 🟢 P3 | App landing page | ARIA (build) | Week 5 |
| 🟢 P3 | Venue sales deck (PDF) | ARIA | Week 4 |

---

## Revenue Projections

| Milestone | Venues | Active Players | Monthly GMV | Platform Revenue |
|-----------|--------|---------------|-------------|-----------------|
| Beta (Month 2) | 5–10 | 1,000 | ₱75K | ₱11K |
| MVP Launch (Month 4) | 15 | 2,500 | ₱750K | ₱110K |
| Standard (Month 8) | 30 | 8,000 | ₱2.1M | ₱315K |
| Year 2 | 75 | 25,000 | ₱8.5M | ₱1.3M |
| Year 3 | 200 | 200,000 | ₱3.6B | ₱432M |

---

## Key Files & References

| Document | Path |
|----------|------|
| Product YAML | `product.yaml` |
| PRD (3 options) | `discovery/prd.md` |
| User Stories | `discovery/user-stories.md` |
| Competitor Analysis | `discovery/competitors.md` |
| GTM Strategy | `discovery/gtm-strategy.md` |
| Target Market (TAM/SAM/SOM) | `discovery/target-market.md` |
| Opportunity Score | `discovery/opportunity-score.md` |
| Design Config | `design/design.yaml` |
| Logo + Sample Screens | `design/assets/` |

---

*Generated by ARIA — 2026-03-04. All data sourced from discovery artifacts.*
