# Discovery: Court Booking

## Target Space

**Industry:** Court Booking

**Problem to Solve:**
The Problem
The indoor sports court industry in the Philippines is booming. Badminton and pickleball are exploding in popularity, with new courts opening across metro and provincial areas. But the booking experience hasn't kept up. It's fragmented, manual, and stuck in the Messenger era.
Right now, if you want to book a badminton or pickleball court, there's no standard process. Every venue does it differently. Some take bookings through Facebook Messenger. Others require you to call. Some use Google Forms. A few only accept walk-ins. There's no way to see which time slots are available without reaching out directly, waiting for a reply, and going back and forth to confirm. It's the equivalent of having to call a movie theater to ask which seats are open — something no one has done in over a decade.
For players, this means wasted time, missed slots, and zero visibility into availability across venues. For court owners, it means managing bookings through chat threads, dealing with double bookings and no-shows, and having no system to track utilization or revenue properly.
There is no unified platform that handles court discovery, real-time availability, and instant booking for indoor sports in the Philippines. Nothing exists in this space.

The Idea
A platform that does for court booking what cinema apps did for movie tickets. Players open the app, browse nearby badminton and pickleball courts, see a real-time grid of available and occupied slots, and book and pay instantly. No messaging. No waiting. No confusion.
On the venue side, the platform provides a free court management system — a digital dashboard that replaces the Messenger chaos. Court owners can manage their schedules, track bookings, handle cancellations, and see usage analytics without paying a single peso. The platform earns through small transaction and processing fees charged to players at the time of booking.
Beyond booking, the platform introduces community features tailored to how these sports are actually played. A "find a player" feature lets individuals discover open groups or fill spots in a game. A digital queue system mirrors the "pila" culture in badminton — where players line up and rotate into games — but removes the need to physically wait at the court.
The Opportunity
Badminton and pickleball are among the fastest-growing recreational sports in the country, driven by a young, urban, digitally native audience that already expects seamless mobile experiences for everything else — food delivery, ride-hailing, travel booking. Court sports booking is one of the last offline holdouts, and the market is wide open. No dominant player exists. The first platform to nail the experience on both the player and venue side wins the category.

## Status

AI is validating market size and competition...

## Next Steps

1. Market validation in progress
2. Competitor analysis
3. Generate 2-3 PRD options for review
