# Competitive Analysis: Court Booking Solution

**Date:** 2026-02-10  
**Product:** Court Booking Solution  
**Market:** Philippines + SEA context

---

## Competitive Landscape Overview

The court booking market is **highly fragmented** with no dominant player in the Philippines. Competition comes from three tiers:

1. **Direct competitors** — Digital booking platforms (global + local)
2. **Indirect competitors** — Manual booking methods (Messenger, phone, walk-in)
3. **Adjacent competitors** — Broader sports/fitness booking platforms

**Key Insight:** The biggest competitor is NOT another platform — it's the **status quo** (Messenger + phone). Any solution must be 10x better than free, familiar tools.

---

## Direct Competitors (Digital Platforms)

### Global Players (Potential PH Entry)

#### 1. **Playfinder** (UK-based)
**Website:** playfinder.com  
**Founded:** 2015  
**Markets:** UK, Europe  
**Status in PH:** Not present

**What They Do:**
- Court booking for tennis, padel, squash, badminton
- Real-time availability + instant booking
- Mobile app (iOS/Android)
- Venue management dashboard

**Pricing:**
- Commission: 3-5% per booking
- SaaS: £50-200/month for venues

**Strengths:**
- Mature product (9+ years)
- Strong brand in UK/EU
- Integrated payments
- Good UX

**Weaknesses:**
- No SEA presence (localization gap)
- Premium positioning (may not fit PH price sensitivity)
- No community/social features
- Focuses on tennis/padel > badminton

**Threat Level:** Medium (could expand to SEA with funding)

---

#### 2. **CourtReserve** (USA)
**Website:** courtreserve.com  
**Founded:** 2014  
**Markets:** USA, Canada  
**Status in PH:** Not present

**What They Do:**
- All-in-one club management + booking
- Membership management, billing, events
- White-label mobile apps
- Focus on tennis clubs

**Pricing:**
- $150-500/month per venue (SaaS)
- Transaction fees: 2.9% + $0.30 (Stripe pass-through)

**Strengths:**
- Comprehensive feature set
- Enterprise-grade
- Strong North American traction

**Weaknesses:**
- Overkill for small PH venues
- High price point ($150/mo = ₱8,400)
- US payment methods (no GCash/PayMaya integration)
- Tennis-focused (badminton secondary)

**Threat Level:** Low (too expensive, not localized)

---

#### 3. **Bookee** (USA/Global)
**Website:** bookee.io  
**Founded:** 2017  
**Markets:** 15+ countries  
**Status in PH:** Not present (some gyms use it)

**What They Do:**
- Multi-sport booking (gyms, courts, studios)
- Class scheduling + facility booking
- Member app + venue dashboard
- Integrated payments

**Pricing:**
- $99-299/month per venue
- Free for <50 bookings/month

**Strengths:**
- Global presence (easier PH expansion)
- Freemium model (low barrier to entry)
- Modern UX

**Weaknesses:**
- Generalist (not court-specific)
- Limited social/community features
- Payment integrations weak in SEA

**Threat Level:** Medium-High (most likely global entrant)

---

### Local/Regional Players

#### 4. **MyCourtPH** (Hypothetical)
**Status:** No known platform exists  
**Research Note:** Searched for PH-specific court booking platforms — none found with significant presence.

**Market Gap:** This is the opportunity. No local platform has captured the market yet.

---

#### 5. **CourtHero (SG-based, hypothetical entry)**
**Status:** Singapore has a few booking platforms (e.g., ActiveSG for public facilities)  
**Threat:** If a well-funded SG startup enters PH market

**Threat Level:** Medium (SEA startups often expand regionally)

---

## Indirect Competitors (Status Quo)

These are the **real competitors** — what venues and players currently use:

### 6. **Facebook Messenger**
**Market Share:** ~90% of current bookings (estimate)

**How It Works:**
- Venues create Facebook Page
- Players DM to check availability
- Manual back-and-forth to confirm time
- Payment: GCash screenshot or cash on arrival

**Strengths:**
- Free
- Everyone already uses it
- Familiar and trusted
- Easy for venues (no new tool to learn)

**Weaknesses:**
- No real-time availability (must ask)
- Inefficient (3-10 messages per booking)
- No payment integration
- No calendar sync
- High no-show rate (no deposits)
- Unscalable for busy venues (inbox overload)

**Our Differentiation:**
- 60 seconds vs. 15 minutes (24x faster)
- Instant confirmation (no waiting)
- Automated reminders (reduce no-shows)
- Payment in-app (no screenshot hassle)

---

### 7. **Phone Calls**
**Market Share:** ~30% (overlaps with Messenger)

**How It Works:**
- Players call venue directly
- Verbal booking, manual log by staff

**Strengths:**
- Immediate human interaction
- Trusted by older demographics

**Weaknesses:**
- Only during business hours
- No visibility (must call to check)
- Miscommunication common
- High staff burden

**Our Differentiation:**
- 24/7 booking (no business hours limit)
- Self-service (free staff for operations)

---

### 8. **Google Forms**
**Market Share:** ~10%

**How It Works:**
- Venue creates Google Form
- Players submit booking request
- Venue confirms via email/text

**Strengths:**
- Free
- Better than pure Messenger (structured data)

**Weaknesses:**
- Not real-time (form is static)
- Manual confirmation still required
- No payment integration
- Poor UX on mobile

**Our Differentiation:**
- Real-time availability
- Instant confirmation (no waiting)

---

### 9. **Walk-ins**
**Market Share:** ~20%

**How It Works:**
- Players show up, hope for availability

**Strengths:**
- Zero friction (just show up)
- Good for spontaneous play

**Weaknesses:**
- High chance of no availability
- Wastes player time (travel for nothing)
- Venues can't predict demand

**Our Differentiation:**
- "Digital queue" feature (reserve next available slot)
- Spontaneity + certainty

---

## Adjacent Competitors

### 10. **ClassPass (Fitness aggregator)**
**Website:** classpass.com  
**Status:** Present in Manila (limited to gyms/studios)

**What They Do:**
- Subscription model (credits for classes)
- Partner venues (gyms, yoga, etc.)
- Booking via app

**Relevance:**
- Could expand to courts (has happened in some markets)
- Consumer-side only (no venue management)

**Differentiation:**
- We offer venue-side SaaS (two-sided marketplace)
- Court-specific features (opponent matching)
- Transactional (not subscription-first)

**Threat Level:** Low (different business model)

---

### 11. **Gymshark, Mindbody (Studio/gym booking)**
**Status:** Mindbody used by some PH gyms

**Relevance:**
- Generic facility booking
- Could be adapted for courts

**Differentiation:**
- Court-specific features (community, skill matching)
- Better UX for per-slot booking (not class-based)

**Threat Level:** Low (not focused on courts)

---

## Competitive Matrix

| Competitor | Type | PH Presence | Price | UX | Court Focus | Community | Threat |
|------------|------|-------------|-------|-----|-------------|-----------|--------|
| Playfinder | Global | None | Med | High | Yes | No | Med |
| CourtReserve | Global | None | High | Med | Tennis | No | Low |
| Bookee | Global | None | Low | High | Multi | No | Med-High |
| Messenger | Status Quo | 90%+ | Free | Low | N/A | Partial | **HIGH** |
| Phone Calls | Status Quo | 30% | Free | Low | N/A | No | Med |
| Google Forms | Status Quo | 10% | Free | Low | N/A | No | Low |
| ClassPass | Adjacent | Limited | High | High | No | Partial | Low |

---

## Competitive Advantages (Our Differentiation)

### 1. **Localization**
- Built for PH market (GCash, PayMaya, Tagalog support)
- Pricing fits local willingness to pay
- Understand Messenger-first culture (migration strategy)

### 2. **Community Features**
- **Find-a-player marketplace** (no competitor has this)
- Skill matching (beginner vs. advanced)
- Digital queue for walk-ins
- Social proof (reviews, player ratings)

### 3. **Two-Sided Focus**
- Not just player-facing (most focus here)
- Robust venue management (rival or beat CourtReserve)
- Aligned incentives (commission model = we win when they win)

### 4. **Vertical Specialization**
- Court booking ONLY (not generalist)
- Badminton/pickleball-first (biggest PH market)
- Court-specific features (opponent matching, skill tiers, equipment rentals)

### 5. **Speed to Market**
- Local team = faster iteration
- Can visit venues in person (relationship building)
- Respond to local trends (pickleball boom)

### 6. **Pricing**
- Freemium for small venues (low barrier to entry)
- Commission model (no upfront cost)
- More affordable than global SaaS ($100-500/mo is ₱5-28k)

---

## Strategic Positioning

**Tagline ideas:**
- "Book your court in 60 seconds" (vs. 15 minutes with Messenger)
- "The cinema app for sports courts"
- "Play more, plan less"

**Positioning:**
- **vs. Messenger:** "We're not replacing Messenger — we're saving you 15 minutes every booking"
- **vs. Global platforms:** "Built for Filipino players and venues"
- **vs. Walk-ins:** "Know before you go"

---

## Competitive Moats (Long-term Defensibility)

1. **Network effects** — More venues → more players → more venues
2. **Data moat** — Player preferences, venue utilization → better matching/pricing
3. **Community lock-in** — Friend groups, regular opponents (hard to switch)
4. **Venue switching costs** — Once calendar is on our platform, migration pain high
5. **Local brand** — "The court booking app in PH" (category ownership)

---

## Vulnerabilities

1. **Global player with funding** — Bookee or Playfinder could launch PH with $1M+ budget
2. **Venue direct booking** — Large chains might build own apps (bypass platform)
3. **Facebook evolves** — If Meta adds booking features to Pages (unlikely but possible)
4. **Low switching costs (players)** — Easy to use multiple apps (must win on UX)

**Mitigation:**
- Move fast, lock in anchor venues
- Build community features (social lock-in)
- Free tier for venues (lower risk of churn)

---

## Key Takeaways

✅ **No dominant local player** — Market is wide open  
✅ **Messenger is the enemy** — Must be 10x better than free  
✅ **Global competitors slow to localize** — First-mover advantage window exists  
✅ **Community features = differentiation** — No one else building this  
✅ **Two-sided marketplace = moat** — Harder to replicate than single-sided  

**Recommended Strategy:** Launch lean MVP, focus on NCR, win on community features, build moat before global players notice.
