---
selected_option: null
generated_at: "2026-02-10T04:20:57.101Z"
---

# Go-to-Market Strategy

## Option 1: Two-Sided Marketplace (Supply-First Launch)

### Channel Strategy
**Primary Channel:** Direct venue acquisition through field sales and relationship building
- **Venue Acquisition:** Direct outreach to 20-30 badminton/pickleball court owners in Metro Manila
- **Player Acquisition:** Organic growth through venue partnerships and referrals
- **Community Seeding:** Partner with existing player groups and badminton clubs
- **Digital Marketing:** Geo-targeted Facebook/Instagram ads focused on sports enthusiasts (₱50K/month budget)

**Secondary Channels:**
- Influencer partnerships with local badminton/pickleball players (₱20K/month)
- Google Ads for court booking keywords (₱30K/month)
- Venue cross-promotion (QR codes, table tents)

### Pricing Model
**Commission-Based (Two-Sided):**
- **Player Fee:** ₱25-50 per booking (5-10% of average ₱500 booking)
- **Venue Commission:** 8% of booking value (venue pays from revenue)
- **Total Take Rate:** 13-18% blended
- **Venue Dashboard:** Free basic tier, ₱8,000/month premium (analytics, marketing tools)

**Value Proposition:**
- Venues: "No upfront cost, only pay when you get bookings"
- Players: "Book in 60 seconds vs 15 minutes with Messenger"

### Launch Timeline
**Months 1-2:** Venue recruitment and onboarding
- Week 1-4: Identify and contact 50 venue prospects
- Week 5-8: Onboard 10 anchor venues, train staff
- Launch with invite-only player beta

**Months 3-4:** Player acquisition and optimization
- Public launch with 10 venues
- Facebook ads campaign launch
- Referral program implementation
- Target: 1,000 registered players

**Months 5-6:** Scale and expand
- Add 10 more venues (20 total)
- Launch find-a-player feature
- Target: 3,000 active players, ₱500K monthly GMV

### Estimated CAC
**Venue CAC:** ₱15,000 per venue
- Direct sales effort (₱10K per venue in sales time/travel)
- Onboarding and training costs (₱3K)
- Initial marketing materials (₱2K)

**Player CAC:** ₱150 per player
- Paid ads: ₱100 (Facebook/Google)
- Referral bonuses: ₱30
- Content/community building: ₱20

**Blended CAC:** ₱8,000 per venue partnership (including associated players)

### Growth Projections
**6 months:**
- 15 venue partners
- 2,500 active players
- ₱750K monthly GMV
- ₱110K monthly revenue (14.7% take rate)
- Break-even on operations

**12 months:**
- 35 venue partners
- 8,000 active players
- ₱2.1M monthly GMV
- ₱315K monthly revenue
- ₱200K monthly profit

**24 months:**
- 75 venue partners (NCR + Cebu)
- 25,000 active players
- ₱8.5M monthly GMV
- ₱1.3M monthly revenue
- ₱900K monthly profit

---

## Option 2: Product-Led Growth (Player-First Launch)

### Channel Strategy
**Primary Channel:** Digital-first player acquisition with viral mechanics
- **Content Marketing:** SEO-optimized blog, YouTube channel showcasing courts
- **Social Media:** TikTok/Instagram content featuring court discovery and booking ease
- **Referral Program:** ₱100 credit for each successful referral
- **App Store Optimization:** Target "badminton courts" and "pickleball booking" keywords

**Secondary Channels:**
- Corporate partnerships (Grab, Foodpanda employee perks)
- University partnerships (UP, Ateneo sports clubs)
- Tournament sponsorships and booth presence

### Pricing Model
**Freemium with Premium Features:**
- **Basic Booking:** Free for players (venues pay 12% commission)
- **Premium Player:** ₱199/month unlimited bookings + priority booking + find-a-player
- **Venue Plans:** ₱5,999/month basic dashboard, ₱12,999/month advanced analytics
- **Transaction Fees:** 2.9% payment processing (passed to player)

**Growth Strategy:**
- Free basic tier drives adoption
- Premium conversion target: 15% of active users
- Venue revenue supplements player revenue

### Launch Timeline
**Months 1-2:** Product development and beta
- Build core booking platform (Option 1: Lean MVP)
- Recruit 5 beta venues through personal networks
- Closed beta with 200 invited players

**Months 3-4:** Public launch and content marketing
- Launch SEO blog and social media presence
- Public app launch with 8 venues
- Influencer partnerships and PR launch
- Target: 2,000 registered players

**Months 5-6:** Viral growth and feature expansion
- Referral program launch
- Add community features (reviews, find-a-player)
- Corporate partnership pilot
- Target: 8,000 players, 15 venues

### Estimated CAC
**Player CAC:** ₱75 per player
- Organic/SEO: ₱20 (content creation costs)
- Paid social: ₱40
- Referrals: ₱15 (referral bonus amortized)

**Venue CAC:** ₱8,000 per venue
- Inbound inquiries from player demand: ₱3K
- Sales and onboarding: ₱5K

**Blended CAC:** ₱85 per customer (player-weighted)

### Growth Projections
**6 months:**
- 12 venue partners
- 6,000 active players (900 premium)
- ₱1.2M monthly GMV
- ₱323K monthly revenue (₱144K commission + ₱179K subscriptions)
- Break-even achieved

**12 months:**
- 25 venue partners
- 18,000 active players (3,600 premium)
- ₱4.5M monthly GMV
- ₱1.26M monthly revenue
- ₱850K monthly profit

**24 months:**
- 60 venue partners
- 45,000 active players (9,000 premium)
- ₱15M monthly GMV
- ₱3.59M monthly revenue
- ₱2.8M monthly profit

---

## Option 3: Partnership-Led Growth (B2B Channel Strategy)

### Channel Strategy
**Primary Channel:** Strategic partnerships with existing sports/fitness ecosystem
- **Sports Equipment Retailers:** Partner with Decathlon, Chris Sports, Toby's Sports for co-marketing
- **Corporate Wellness Programs:** Direct sales to HR departments for employee perks
- **Sports Clubs and Associations:** Partner with Philippine Badminton Association, local clubs
- **Fitness Apps Integration:** Partner with MyFitnessPal, Strava for cross-promotion

**Secondary Channels:**
- Franchise/licensing model for provincial expansion
- White-label solutions for large venue chains
- Event marketing at tournaments and sports festivals

### Pricing Model
**B2B2C Revenue Sharing:**
- **Corporate Accounts:** ₱50,000-200,000 annual contracts for employee booking credits
- **Partner Revenue Share:** 30% of booking fees to retail/club partners
- **White-Label Licensing:** ₱25,000/month + 5% of GMV for venue chains
- **Venue Commission:** 10% (reduced due to partner-driven demand)

**Enterprise Features:**
- Bulk booking management
- Corporate reporting and analytics
- Employee wellness tracking
- Custom branding options

### Launch Timeline
**Months 1-3:** Partnership development and pilot programs
- Sign 3 major corporate clients (Ayala, SM, Jollibee)
- Partner with 2 equipment retailers
- Launch corporate pilot with 8 venues
- Target: 1,000 corporate-sponsored bookings

**Months 4-6:** Channel partner scaling
- Expand corporate program to 10 companies
- Launch retail partnership activation
- Add sports club partnerships
- Target: 5,000 monthly corporate users, 15 venues

**Months 7-12:** Market expansion through partners
- Franchise model launch in Cebu through local partner
- White-label deal with major venue chain
- Scale corporate program to 25 companies

### Estimated CAC
**Corporate CAC:** ₱25,000 per corporate client
- Enterprise sales cycle (₱15K in sales effort)
- Custom onboarding and integration (₱8K)
- Account management setup (₱2K)

**End-User CAC:** ₱30 per player
- Subsidized by corporate accounts
- Partner channel referrals
- Lower acquisition cost due to pre-qualified audience

**Venue CAC:** ₱5,000 per venue
- Inbound demand from corporate partnerships
- Reduced sales effort due to proven corporate demand

### Growth Projections
**6 months:**
- 18 venue partners
- 15 corporate accounts (3,000 employees with access)
- ₱1.8M monthly GMV
- ₱540K monthly revenue (30% take rate on corporate bookings)
- ₱280K monthly profit

**12 months:**
- 35 venue partners
- 35 corporate accounts + 2 franchise territories
- ₱6.5M monthly GMV
- ₱2.27M monthly revenue
- ₱1.65M monthly profit

**24 months:**
- 80 venue partners across 4 cities
- 75 corporate accounts + 5 franchise territories
- ₱18M monthly GMV
- ₱6.3M monthly revenue
- ₱4.9M monthly profit

---

## Recommendation

**Start with Option 1: Two-Sided Marketplace (Supply-First Launch)** for the following reasons:

1. **Market Reality:** The biggest barrier is venue adoption, not player demand. Players already want better booking - venues need convincing to change from "free" Messenger.

2. **Network Effects:** Getting quality venue partners first creates sustainable competitive advantage. Players will follow venues, but venues won't join without critical mass of bookings.

3. **Revenue Certainty:** Commission model aligns incentives and ensures immediate revenue with each booking. No dependency on premium conversion rates.

4. **Competitive Moats:** Direct venue relationships are harder for global competitors to replicate quickly compared to digital marketing strategies.

5. **Cash Flow:** Revenue starts immediately with first bookings vs waiting for subscription conversions or corporate sales cycles.

**Recommended Hybrid Approach:** Launch with Option 1 in months 1-6, then layer in elements of Option 2 (premium features) in months 7-12, and Option 3 (corporate partnerships) in year 2 for diversification and expansion.