# Product Requirements Document: Court Booking Solution

**Date:** 2026-02-10  
**Version:** 1.0 (Discovery)  
**Product:** Court Booking Solution  
**Phase:** Discovery → Design

---

## Document Purpose

This PRD defines **three implementation options** for the Court Booking Solution, ranging from lean MVP to full-featured platform. Each option balances time-to-market, development cost, feature richness, and market validation needs.

---

## Product Vision

**For players:** Book your court in 60 seconds, find opponents, and track your games — all in one app.

**For venue owners:** Automate bookings, increase utilization, reduce no-shows, and build customer loyalty — without hiring more staff.

---

## Success Metrics

### North Star Metric:
**Monthly Gross Merchandise Value (GMV)** — Total value of bookings processed

### Supporting Metrics:

**Player-side:**
- Monthly Active Players (MAP)
- Booking conversion rate (search → booking)
- Average bookings per player per month
- Player retention (% active after 30/60/90 days)
- Time to complete booking (target: <2 minutes)

**Venue-side:**
- Active venue partners
- Average court utilization (target: 75%+)
- No-show rate (target: <10%)
- Revenue increase per venue (vs. manual)
- Venue retention rate

**Platform:**
- GMV per active player (ARPU)
- Take rate (commission %)
- CAC (Customer Acquisition Cost) — player & venue
- LTV:CAC ratio (target: >3:1)

---

## Three Implementation Options

| Criteria | Option 1: Lean MVP | Option 2: Standard | Option 3: Full-Featured |
|----------|-------------------|-------------------|------------------------|
| **Timeline** | 6-8 weeks | 12-16 weeks | 20-24 weeks |
| **Dev Cost** | ₱400-600K | ₱1-1.5M | ₱2-3M |
| **Team Size** | 2 devs + 1 designer | 3 devs + 1 designer + 1 PM | 4 devs + 2 designers + 1 PM + 1 QA |
| **Features** | Core booking only | + Community basics | + Full social, AI matching |
| **Go-to-Market** | 5-10 venues (NCR) | 20-30 venues (NCR) | 50+ venues (NCR + Cebu) |
| **Risk** | High (unproven) | Medium (validated MVP) | Low (proven concept) |

---

# Option 1: Lean MVP (Validate Core Hypothesis)

**Goal:** Prove that players and venues will adopt digital booking over Messenger/phone. Validate willingness to pay.

**Timeline:** 6-8 weeks  
**Budget:** ₱400-600K  
**Launch Strategy:** Invite-only beta, 5-10 anchor venues

---

## P0 Features (Must-Have)

### Player-Facing (Mobile Web)

#### 1. **Discovery**
- Browse venues (list + map view)
- Filter by location, sport (badminton/pickleball), date, time
- View venue details (photos, address, amenities, pricing)

#### 2. **Real-Time Availability**
- Calendar view (week view, time slots)
- Court availability status (available / booked / blocked)
- Pricing per slot

#### 3. **Booking Flow**
- Select venue + court + time slot
- Login/register (email/password, Google OAuth)
- Confirm booking details
- Payment (GCash, PayMaya, card via SymphPay)
- Instant confirmation (booking ID, QR code)

#### 4. **My Bookings**
- Upcoming bookings
- Booking history
- Booking details (QR code, venue info)
- Cancel booking (if allowed by policy)

#### 5. **Notifications**
- Booking confirmation (email + SMS)
- Reminder 24h before (SMS)
- Booking cancelled/modified alert

---

### Venue Owner Dashboard (Web)

#### 1. **Calendar Management**
- View all courts + time slots
- Block/unblock slots (maintenance, private events)
- Manual booking creation (walk-ins, phone bookings)

#### 2. **Booking Management**
- View upcoming/past bookings
- Check-in players (scan QR or manual confirm)
- Cancel/modify bookings
- No-show tracking

#### 3. **Venue Settings**
- Venue info (name, address, photos, amenities)
- Court configuration (number of courts, names)
- Pricing (per hour, per slot)
- Operating hours
- Cancellation policy (hours before, refund %)

#### 4. **Payouts**
- View earnings (daily/weekly/monthly)
- Payout schedule (weekly to bank account)
- Transaction history

#### 5. **Basic Analytics**
- Bookings today/this week/this month
- Revenue summary
- Utilization rate (% of slots booked)

---

## P1 Features (Nice-to-Have, post-MVP)

- Multi-court booking (book 2+ courts at once)
- Promo codes (venue-created discounts)
- Player reviews/ratings for venues
- Venue photos from players
- Email receipts (PDF)

---

## P2 Features (Future)

- Mobile app (native iOS/Android)
- Community features (find-a-player, digital queue)
- Loyalty/rewards program
- Equipment rentals
- Dynamic pricing

---

## Technical Architecture (MVP)

**Stack:**
- Frontend: Next.js 15, Tailwind v4, shadcn/ui
- Backend: Firebase (Firestore, Auth, Functions)
- Payments: SymphPay integration
- Hosting: Firebase App Hosting (prod), Caddy/VPS (dev)
- Notifications: Twilio (SMS), SendGrid (email)

**Key Collections (Firestore):**
```
venues/{venueId}
  - name, location, courts[], pricing, policies

bookings/{bookingId}
  - venueId, courtId, playerId, slot, status, payment

players/{playerId}
  - name, email, phone, bookingHistory[]

payouts/{payoutId}
  - venueId, amount, status, transactions[]
```

---

## Open Questions (MVP)

1. **Cancellation policy:** Standard 24h refund? Or venue-specific?
2. **Payment flow:** Pre-pay 100% or deposit (50%) + balance on arrival?
3. **No-show penalty:** Charge no-show fee? Ban after X no-shows?
4. **Venue onboarding:** Self-serve or assisted (we do initial setup)?
5. **Commission split:** 5% player + 7% venue = 12% total?
6. **Minimum booking:** 1 hour? Or 30-min slots allowed?

---

# Option 2: Standard (Validated MVP + Community Features)

**Goal:** Launch with validated core + basic community features (find-a-player, reviews). Build defensibility via social graph.

**Timeline:** 12-16 weeks  
**Budget:** ₱1-1.5M  
**Launch Strategy:** Public launch, 20-30 venues, paid marketing (₱100K budget)

---

## P0 Features (All MVP + Below)

### Additional Player Features

#### 6. **Find-a-Player**
- Post "looking for player" (date, time, venue, skill level)
- Browse open invites
- Join/apply to play
- In-app messaging (basic)

#### 7. **Reviews & Ratings**
- Rate venues (1-5 stars)
- Written reviews
- Photo uploads
- Helpful votes on reviews

#### 8. **Player Profile**
- Profile photo
- Skill level (beginner/intermediate/advanced)
- Preferred sports
- Play history (total games)
- Friends list (basic)

#### 9. **Group Booking**
- Invite friends to booking
- Split payment (each pays their share)
- Group chat for booking

---

### Additional Venue Features

#### 10. **Marketing Tools**
- Promo codes (percentage or fixed discount)
- Off-peak pricing (dynamic pricing by time)
- Email marketing to past customers (via platform)

#### 11. **Customer Management**
- View customer list (who's booked)
- Customer booking history
- Tag VIP customers
- Manual loyalty points

#### 12. **Enhanced Analytics**
- Peak hours heatmap
- Customer demographics
- Revenue by court
- Repeat customer rate
- Compare vs. previous period

---

## P1 Features (Post-launch)

- Digital queue (walk-in waitlist)
- Equipment rental module (rackets, shoes)
- Tournament creation (venue-hosted)
- Membership/subscription plans (monthly unlimited)

---

## P2 Features (Future)

- Mobile app (native)
- AI-powered opponent matching
- Live court cameras (via venue)
- Performance tracking (game stats)
- Leaderboards

---

## Technical Additions

**New collections:**
```
players/{playerId}/friends/{friendId}
players/{playerId}/reviews/{reviewId}
lfp_posts/{postId}  // looking-for-player posts
conversations/{conversationId}/messages/{messageId}
```

**Integrations:**
- Push notifications (FCM)
- Image storage (Firebase Storage)
- Real-time messaging (Firestore listeners)

---

## Open Questions (Standard)

1. **Skill verification:** Self-reported or validated somehow?
2. **Messaging moderation:** How to prevent spam/abuse?
3. **Friend matching algorithm:** Prioritize friends-of-friends?
4. **Review moderation:** Manual review or auto-publish?
5. **Off-peak pricing:** Venue-controlled or platform-suggested?

---

# Option 3: Full-Featured (Complete Platform)

**Goal:** Launch category-defining platform with AI matching, native apps, full venue automation, and tournament/league features.

**Timeline:** 20-24 weeks  
**Budget:** ₱2-3M  
**Launch Strategy:** Major launch, 50+ venues, PR campaign, influencer partnerships

---

## P0 Features (All Standard + Below)

### Advanced Player Features

#### 13. **AI-Powered Matching**
- Match players by skill (analyzed from game history)
- Personality fit (playing style, competitiveness)
- Schedule compatibility
- Location preferences

#### 14. **Performance Tracking**
- Log game results (win/loss)
- Track stats (games played, win rate)
- Skill rating (ELO-style)
- Progress over time

#### 15. **Digital Queue (Walk-ins)**
- Join queue for next available court
- Real-time position updates
- SMS alert when court ready
- Reserve from queue (15-min window)

#### 16. **Social Features**
- Follow other players
- Activity feed (friends' games, reviews)
- Challenges (direct challenge to play)
- Leaderboards (venue, city, national)

#### 17. **Native Mobile App**
- iOS + Android (React Native or Flutter)
- Push notifications
- Location-based discovery
- Faster performance

---

### Advanced Venue Features

#### 18. **Equipment & Rentals**
- Manage inventory (rackets, shoes, balls)
- Rental bookings (with/without court)
- Pricing per item
- Damage fees

#### 19. **F&B/Locker Integration**
- Sell items (water, snacks)
- Locker rentals
- Bundled packages (court + equipment + locker)

#### 20. **Tournament Management**
- Create tournaments (brackets, scheduling)
- Registration + payment
- Live scoring
- Winner announcements

#### 21. **Membership Plans**
- Monthly unlimited bookings
- Tiered plans (off-peak vs. all-access)
- Auto-renewal
- Member-only perks

#### 22. **Staff Management**
- Multi-user accounts (owner, manager, front desk)
- Role permissions
- Staff check-in interface (tablet mode)

#### 23. **Advanced Analytics**
- Predictive demand (ML-based)
- Customer lifetime value
- Churn prediction
- A/B testing (pricing experiments)

---

## P1 Features (Post-launch)

- Live court cameras (IoT integration)
- Smart lock integration (keyless court access)
- Voice booking (Alexa/Google Assistant)
- Corporate accounts (team bookings, billing)

---

## P2 Features (Future)

- Coaching marketplace (book coaches)
- League management (seasonal play)
- Betting/prediction games (legal check)
- Virtual tournaments (cross-venue)
- Wearable integration (fitness trackers)

---

## Technical Additions

**Advanced features:**
- Machine learning (TensorFlow.js or Firebase ML)
- Real-time multiplayer (WebSockets)
- Video storage (for proof of play, disputes)
- Advanced caching (Redis/Firebase Realtime DB)
- Multi-region deployment (SEA expansion)

**New collections:**
```
tournaments/{tournamentId}
leagues/{leagueId}
challenges/{challengeId}
inventory/{venueId}/items/{itemId}
memberships/{membershipId}
staff/{venueId}/users/{userId}
```

---

## Open Questions (Full-Featured)

1. **AI matching:** What data points to train on? Privacy concerns?
2. **Tournament liability:** Insurance if player injury during tournament?
3. **Equipment tracking:** RFID tags or manual?
4. **Membership vs. pay-per-use:** Can users mix both?
5. **Staff payroll:** Integrate payroll or just scheduling?
6. **IoT security:** How to secure smart locks?

---

# Comparison Summary

| Feature Category | Lean MVP | Standard | Full-Featured |
|-----------------|----------|----------|---------------|
| **Core booking** | ✅ | ✅ | ✅ |
| **Real-time availability** | ✅ | ✅ | ✅ |
| **Payments (SymphPay)** | ✅ | ✅ | ✅ |
| **Basic venue dashboard** | ✅ | ✅ | ✅ |
| **Find-a-player** | ❌ | ✅ | ✅ |
| **Reviews/ratings** | ❌ | ✅ | ✅ |
| **Group booking** | ❌ | ✅ | ✅ |
| **Off-peak pricing** | ❌ | ✅ | ✅ |
| **Digital queue** | ❌ | ❌ | ✅ |
| **AI matching** | ❌ | ❌ | ✅ |
| **Performance tracking** | ❌ | ❌ | ✅ |
| **Native mobile app** | ❌ | ❌ | ✅ |
| **Equipment rentals** | ❌ | ❌ | ✅ |
| **Tournaments** | ❌ | ❌ | ✅ |
| **Membership plans** | ❌ | ❌ | ✅ |

---

# Recommended Approach: **Phased Rollout**

## Phase 1: Lean MVP (Weeks 1-8)
- Build and launch core booking
- Onboard 5-10 anchor venues
- Acquire 500-1,000 early adopters
- Validate product-market fit
- **Metrics to validate:** 60%+ booking completion rate, <5% churn, 3+ bookings/user/month

## Phase 2: Standard (Weeks 9-16)
- Add community features (find-a-player, reviews)
- Expand to 20-30 venues
- Scale to 5,000+ players
- **Metrics to validate:** 10% users use find-a-player, 30% leave reviews

## Phase 3: Full-Featured (Weeks 17-24)
- Native app launch
- Advanced features (AI, tournaments)
- Expand to 50+ venues
- Launch second city (Cebu)
- **Metrics to validate:** 50K players, ₱10M GMV/month

---

# Risk Mitigation

| Risk | Impact | Probability | Mitigation |
|------|--------|-------------|------------|
| Venues resist change | High | Medium | Free trial, white-label option, hands-on onboarding |
| Players don't see value | High | Medium | Price parity with Messenger (convenience is free), refer-a-friend incentives |
| Payment fraud | Medium | Low | SymphPay fraud detection, ID verification for high-value bookings |
| Technical debt (scaling) | Medium | Medium | Firebase scales automatically, modular architecture for refactor |
| Competitor enters market | Medium | Medium | Move fast, lock in anchor venues, build community moat |

---

# Next Steps

1. **Stakeholder review:** Choose option (recommend: Lean MVP → Standard)
2. **User research:** Interview 10 venue owners, 20 players
3. **Design phase:** Wireframes, high-fidelity mockups
4. **Technical spec:** Detailed architecture, API design
5. **Pilot recruitment:** Identify 5 anchor venues for beta

---

**Document Owner:** Discovery Agent  
**Last Updated:** 2026-02-10  
**Status:** Awaiting stakeholder review
