# Product Brief: Court Booking Solution

**Date:** 2026-02-10  
**Phase:** Discovery  
**Industry:** Indoor Sports / Court Booking

---

## The Opportunity

The indoor sports industry in the Philippines—particularly badminton and pickleball—is experiencing explosive growth. Metro Manila alone has seen hundreds of new courts open in the past 3 years. However, the booking experience remains stuck in the pre-digital era: Messenger groups, phone calls, Google Forms, and walk-ins dominate. Players waste time calling multiple venues to find availability. Venue owners lose revenue to no-shows and inefficient scheduling.

**Market Signal:** What cinema booking apps did for movie tickets (Sureseats, CatchPlay) can be done for court booking. Real-time availability + instant booking/payment = massive convenience gain.

---

## The Problem

### For Players:
- **No visibility into availability** — Must call/message multiple venues to find an open slot
- **Booking friction** — Manual coordination via Messenger, screenshots of bank transfers, waiting for confirmations
- **Time waste** — Average 15-30 minutes to secure a court booking
- **No community features** — Finding partners ("looking for 1 more") happens in scattered FB groups
- **Payment hassle** — Cash on arrival or bank transfer with proof screenshot

### For Venue Owners:
- **Revenue leakage** — No-shows common with informal bookings
- **Manual admin burden** — Staff spend hours managing Messenger/calls instead of operations
- **Suboptimal utilization** — Prime slots go unfilled because potential customers can't see availability
- **No customer data** — Can't build loyalty programs or targeted marketing
- **Payment delays** — Chasing payments, reconciling cash vs. transfers

---

## The Solution

A **unified court booking platform** that provides:

### Core Features (Cinema booking model):
1. **Real-time availability map** — See all courts, all slots, instant status
2. **Instant booking + payment** — Reserve in 60 seconds, pay with GCash/card
3. **Automated confirmations** — QR codes, SMS/email receipts
4. **Cancellation policies** — Clear rules, automated refunds

### Community Features (Differentiation):
5. **Find-a-player marketplace** — "Need 1 for doubles at 7pm"
6. **Digital queue system** — Drop-in play when courts free up
7. **Skill matching** — Find opponents at your level
8. **Social features** — Track your games, leaderboards, challenges

### Venue Owner Dashboard:
9. **Yield management** — Dynamic pricing for off-peak hours
10. **Analytics** — Utilization rates, customer behavior, revenue forecasting
11. **Automated reminders** — Reduce no-shows
12. **Inventory management** — Racket rentals, shuttlecocks, F&B

---

## Why Us (Symph)

1. **Local market expertise** — Based in PH, understand the Messenger-first booking culture
2. **B2B SaaS strength** — Can build venue owner tools, not just consumer app
3. **Payment integration** — SymphPay integration ready (GCash, PayMaya, card)
4. **Rapid prototyping** — Agency App Starter + Firebase = MVP in weeks
5. **Community building** — Can leverage social features others ignore

---

## Success Criteria

### Year 1:
- **10 venue partners** (Metro Manila)
- **5,000 registered players**
- **1,000 bookings/month** (₱500 avg = ₱500k GMV/month)
- **80% booking completion rate** (vs. 60% with manual)

### Year 2:
- **50 venues** (NCR + key provinces)
- **50,000 players**
- **20,000 bookings/month** (₱10M GMV/month)
- **Break-even on unit economics**

### Revenue Model:
- **Option A (Commission):** 10-15% booking fee (split: 5-7% from player, 5-8% from venue)
- **Option B (SaaS):** ₱5-10k/month per venue + 5% transaction fee
- **Option C (Hybrid):** Freemium (free basic) + ₱15k/month premium + 8% commission

---

## Key Risks

1. **Venue adoption** — Owners may resist change, prefer "no middleman"
   - *Mitigation:* Free trial, white-label option, emphasize revenue increase
2. **Network effects** — Need critical mass of venues for player value
   - *Mitigation:* Launch city-by-city (start NCR), secure anchor venues
3. **Payment trust** — PH consumers wary of new payment platforms
   - *Mitigation:* Integrate SymphPay + GCash/PayMaya (familiar brands)
4. **Competition** — Global players may enter (Playfinder, CourtReserve)
   - *Mitigation:* First-mover advantage, localization, community features

---

## Why Now?

- **Post-pandemic sports boom** — Indoor sports recovering strong
- **Mobile payment adoption** — GCash users grew 40%+ YoY
- **"Uber for X" proven** — Market educated on on-demand platforms
- **No dominant incumbent** — Market wide open in PH

---

## Next Steps

1. **Validate market size** — Research actual court counts, booking volumes
2. **Interview venue owners** — Understand pain points, willingness to pay
3. **Interview players** — Validate booking friction, test community features
4. **Competitive analysis** — Deep dive on global platforms, PH startups
5. **Build PRD** — Define MVP scope (lean vs. full-featured)
