# Target Market Analysis: Court Booking Solution

**Date:** 2026-02-10  
**Product:** Court Booking Solution  
**Geography:** Philippines (initial focus: Metro Manila)

---

## Market Size Estimates

### TAM (Total Addressable Market)
**Southeast Asia Indoor Sports Court Booking Market**

*Assumptions:*
- SEA population: ~680M
- Urban population: ~50% = 340M
- Sports-active demographic (18-45): ~30% = 102M
- Indoor court sports participants: ~5% = 5.1M
- Average spending: $200/year on court bookings
- **TAM = 5.1M × $200 = $1.02B/year**

*Platform take (10-15% commission):*
- **Addressable revenue: $100-150M/year** (SEA-wide)

### SAM (Serviceable Addressable Market)
**Philippines Indoor Sports Court Booking**

*Assumptions:*
- PH population: ~115M
- Urban population: ~55M
- Sports-active (18-45): ~16M
- Indoor court sports participants: ~8% = 1.28M
  - Badminton: 900K regular players (est.)
  - Basketball indoor: 250K
  - Pickleball: 80K (fastest growing)
  - Tennis indoor: 50K
- Average annual spending: ₱12,000/year (₱1,000/month)
- **SAM = 1.28M × ₱12,000 = ₱15.36B/year (~$275M)**

*Platform revenue potential (12% avg commission):*
- **₱1.84B/year ($33M)** — serviceable revenue

### SOM (Serviceable Obtainable Market)
**Year 1-3 Realistic Capture (Metro Manila + Key Cities)**

*Year 1 (Metro Manila penetration):*
- NCR courts: ~800 badminton/pickleball courts (est.)
- Target: 10 venue partners (1.25% of venues)
- Active players per venue: 500 avg
- Total addressable players: 5,000
- Bookings per player per month: 3
- Average booking value: ₱500
- **Year 1 GMV: 5,000 × 3 × 12 × ₱500 = ₱90M**
- **Platform revenue (12%): ₱10.8M (~$195K)**

*Year 2 (NCR expansion):*
- Venue partners: 50 (6% penetration)
- Active players: 50,000
- **Year 2 GMV: ₱900M**
- **Platform revenue: ₱108M (~$1.95M)**

*Year 3 (National expansion):*
- Venue partners: 200 (5 cities)
- Active players: 200,000
- **Year 3 GMV: ₱3.6B**
- **Platform revenue: ₱432M (~$7.8M)**

---

## Geographic Focus

### Phase 1: Metro Manila (Months 1-12)
**Priority zones:**
1. **Quezon City** — Highest court density (200+ courts)
2. **Makati CBD** — Corporate players, high willingness to pay
3. **BGC Taguig** — Expat community, premium pricing
4. **Pasig/Mandaluyong** — Growing middle-class market
5. **Alabang** — South corridor hub

**Why NCR first:**
- 60% of PH's indoor courts concentrated here
- Highest smartphone/digital payment penetration
- Density enables network effects faster
- Easier for team to onboard venues in person

### Phase 2: Key Provincial Cities (Year 2)
1. **Cebu City** — 2nd largest market, 150+ courts
2. **Davao City** — Southern hub, strong badminton culture
3. **Iloilo City** — Growing sports scene
4. **Cagayan de Oro** — Mindanao expansion

### Phase 3: Regional Expansion (Year 3+)
- Baguio, Bacolod, Pampanga, Laguna

---

## Customer Personas

## Persona 1: **Marc, The Competitive Player**

**Demographics:**
- Age: 28
- Occupation: Software engineer
- Income: ₱80K/month
- Location: Ortigas, Pasig

**Behaviors:**
- Plays badminton 3-4x per week (after work, weekends)
- Part of a regular group, but also does drop-in games
- Currently books via Messenger group chats
- Spends ₱2,000-3,000/month on courts

**Pain Points:**
- "I waste 20 minutes every week trying to find a court"
- "Group chat is chaotic — 100 messages to book one slot"
- "Venues double-book, we show up and court is taken"
- "Hard to find opponents at my skill level when group is busy"

**Goals:**
- Book a court in under 2 minutes
- Find reliable partners for doubles
- Track his game stats
- Discover new venues

**Willingness to Pay:**
- Would pay ₱50-100 extra per booking for convenience
- Values time over cost

---

## Persona 2: **Sarah, The Social Player**

**Demographics:**
- Age: 24
- Occupation: Marketing associate
- Income: ₱40K/month
- Location: BGC, Taguig

**Behaviors:**
- Plays pickleball 1-2x per week (new to the sport)
- Goes with friends, sometimes solo
- Discovers venues via Instagram, books via DM
- Spends ₱800-1,200/month

**Pain Points:**
- "I never know which courts are open for walk-ins"
- "Intimidated to book alone — wish I could find other beginners"
- "Payment is awkward — bank transfer screenshots, waiting for confirmation"
- "Forget to bring cash for rentals"

**Goals:**
- Easy discovery of beginner-friendly venues
- Find other players to go with
- Seamless mobile payment
- Social proof (reviews, photos)

**Willingness to Pay:**
- Prefers transparent pricing
- Would use free tier, upgrade for premium features (social matching)

---

## Persona 3: **David, The Venue Owner**

**Demographics:**
- Age: 42
- Business: Owns 4 badminton courts in Quezon City
- Revenue: ₱300K/month
- Staff: 2 front desk, 1 maintenance

**Behaviors:**
- Manages bookings via Facebook Page + Messenger
- Uses Google Sheets for schedules (manually updated)
- Accepts GCash, bank transfer, cash
- Peak hours: 6-9pm weekdays, 7am-7pm weekends

**Pain Points:**
- "We spend 3-4 hours daily just answering Messenger bookings"
- "No-shows cost us ₱20-30K/month"
- "Off-peak hours (10am-4pm weekdays) are empty"
- "Can't identify repeat customers or build loyalty"
- "Competitors are stealing customers — no way to retain them"

**Goals:**
- Automate booking admin (save staff time)
- Increase utilization to 80%+ (currently 65%)
- Reduce no-shows with deposits
- Dynamic pricing for off-peak
- Customer database for marketing

**Willingness to Pay:**
- Currently spends ₱0 on booking software (DIY)
- Would pay ₱5-10K/month if it increases revenue by ₱30K+
- Commission model acceptable if it brings new customers

---

## Persona 4: **Jenny, The Weekend Warrior Mom**

**Demographics:**
- Age: 38
- Occupation: HR manager
- Income: ₱90K/month
- Location: Alabang, Muntinlupa
- Family: Married, 2 kids

**Behaviors:**
- Plays badminton 1x per week (Saturday mornings with friends)
- Books 1-2 weeks in advance
- Prefers venues with amenities (parking, F&B, shower)
- Spends ₱600-800 per session

**Pain Points:**
- "Limited free time — need to book quickly when available"
- "Venues near me don't publish schedules online"
- "Have to coordinate with 3 other moms — group chat nightmare"
- "Need venues with parking and safe for kids (they come along)"

**Goals:**
- Find family-friendly venues
- Book in advance with easy rescheduling
- Group booking features (split payment)
- Reliable service (no surprises)

**Willingness to Pay:**
- Values convenience highly
- Would pay premium for quality venues
- Price-sensitive during off-peak exploration

---

## Willingness to Pay Analysis

### Player Segment:

| Segment | Monthly Bookings | Avg Booking Value | Monthly Spend | Acceptable Fee | Revenue/User/Mo |
|---------|-----------------|-------------------|---------------|----------------|-----------------|
| Competitive (30%) | 12 | ₱500 | ₱6,000 | ₱100/booking | ₱1,200 |
| Social (40%) | 6 | ₱450 | ₱2,700 | ₱50/booking | ₱300 |
| Weekend (30%) | 4 | ₱600 | ₱2,400 | ₱75/booking | ₱300 |

**Blended ARPU (player side):** ₱600/month per active user

### Venue Segment:

| Venue Size | Courts | Monthly Bookings | GMV/Month | Commission (12%) | SaaS Alt. |
|------------|--------|-----------------|-----------|------------------|-----------|
| Small | 2-3 | 200 | ₱100K | ₱12K | ₱5K/mo |
| Medium | 4-6 | 500 | ₱250K | ₱30K | ₱10K/mo |
| Large | 7+ | 1,000+ | ₱500K+ | ₱60K+ | ₱20K/mo |

**Preferred model (venues):** Hybrid — Free basic tier (online booking widget) + Premium ₱8-15K/month (analytics, marketing tools, loyalty) + 5-8% transaction fee

---

## Market Segmentation Strategy

### Primary Target (Year 1):
**Medium-sized venues (4-6 courts) in NCR**
- Represent 40% of total courts
- High enough revenue to value automation
- Small enough to need external marketing (no brand yet)
- Decision-makers accessible (owner-operators)

**Competitive players (25-35 years old)**
- Highest booking frequency
- Early adopters of digital tools
- Influencers in their player communities
- Will tolerate bugs for convenience

### Secondary Target (Year 2):
- Large venues (seeking enterprise features)
- Social players (scale volume)
- Provincial cities (geographic expansion)

### Tertiary (Year 3+):
- Small venues (1-2 courts) — may need ultra-lean pricing
- Corporate bookings (team building events)
- Tournament organizers (bulk booking)

---

## Key Insights

1. **TAM is $100M+ (SEA), SAM is $33M (PH)** — Large enough to build meaningful business
2. **Year 3 SOM: $7.8M revenue** — Achievable with 1% market penetration
3. **Dual-sided marketplace** — Must solve for BOTH players AND venues
4. **Geographic density critical** — Network effects only work city-by-city
5. **Willingness to pay exists** — Players value time, venues value automation
6. **Commission > SaaS early on** — Align incentives, reduce upfront friction

---

## Go-to-Market Strategy (Summary)

1. **Anchor venues first** (5-10 in NCR, cover key zones)
2. **Seed players from venue communities** (existing customers)
3. **Localized marketing** (geo-targeted ads, venue partnerships)
4. **City-by-city rollout** (not national launch)
5. **Community features as moat** (hard for global players to replicate)
