# User Stories: Court Booking Solution

**Date:** 2026-02-10  
**Product:** Court Booking Solution  
**Format:** As a [persona], I want to [action], so that [benefit]

---

## Story Format & Priority

**Priority Levels:**
- **P0 (Must-Have):** Core functionality, blocks launch
- **P1 (Should-Have):** Important but not blocking
- **P2 (Nice-to-Have):** Future enhancement

**Acceptance Criteria:** Defined for each story

---

# Player Persona Stories

## Epic 1: Discovery & Browsing

### US-P001: Browse Venues (P0)
**As a** player  
**I want to** browse all available venues in my city  
**So that** I can discover courts near me

**Acceptance Criteria:**
- Can view venues as a list or on a map
- Can filter by sport (badminton, pickleball, tennis)
- Can filter by location (district or radius)
- Can see venue photos, rating, and address at a glance
- Can sort by distance, rating, or price

---

### US-P002: View Venue Details (P0)
**As a** player  
**I want to** view detailed information about a venue  
**So that** I can decide if it suits my needs

**Acceptance Criteria:**
- See venue name, address, contact info
- See all photos (minimum 3)
- See amenities (parking, lockers, shower, F&B)
- See pricing per hour/slot
- See average rating and review count
- See operating hours
- See cancellation policy

---

### US-P003: Search by Date/Time (P0)
**As a** player  
**I want to** search for available courts on a specific date and time  
**So that** I can find a court when I'm free

**Acceptance Criteria:**
- Can select date (calendar picker)
- Can select time range (dropdown or slider)
- Results show only venues with availability
- Can see number of available courts per venue

---

## Epic 2: Booking Flow

### US-P004: View Real-Time Availability (P0)
**As a** player  
**I want to** see real-time court availability in a calendar view  
**So that** I know exactly which slots are open

**Acceptance Criteria:**
- Calendar shows week view (7 days)
- Each time slot shows status: available / booked / blocked
- Can navigate to next/previous week
- Availability updates in real-time (no stale data)
- Shows price per slot

---

### US-P005: Select Court & Time Slot (P0)
**As a** player  
**I want to** select a specific court and time slot  
**So that** I can book it

**Acceptance Criteria:**
- Can click on an available slot
- Slot is highlighted/locked for 5 minutes (reservation hold)
- Shows court name/number
- Shows total price
- Can change selection before confirming

---

### US-P006: Create Account / Login (P0)
**As a** player  
**I want to** quickly create an account or log in  
**So that** I can complete my booking

**Acceptance Criteria:**
- Can sign up with email + password
- Can sign in with Google OAuth
- Can sign in with phone number (OTP)
- Form pre-fills name from OAuth
- Terms & conditions checkbox
- Redirects to booking confirmation after signup

---

### US-P007: Complete Payment (P0)
**As a** player  
**I want to** pay securely with my preferred method  
**So that** I can confirm my booking instantly

**Acceptance Criteria:**
- Payment methods: GCash, PayMaya, Credit/Debit Card
- SymphPay integration (PCI-compliant)
- Shows booking summary before payment
- Shows breakdown (court fee + platform fee + total)
- Can apply promo code
- Receives instant confirmation after successful payment

---

### US-P008: Receive Booking Confirmation (P0)
**As a** player  
**I want to** receive a confirmation with all details  
**So that** I have proof of my booking

**Acceptance Criteria:**
- Confirmation page shows booking ID, QR code, venue details, time
- Email sent with booking details (within 1 minute)
- SMS sent with booking ID and venue address
- QR code can be saved to phone
- "Add to calendar" button (Google Calendar, Apple Calendar)

---

## Epic 3: Booking Management

### US-P009: View My Bookings (P0)
**As a** player  
**I want to** see all my upcoming and past bookings  
**So that** I can manage my schedule

**Acceptance Criteria:**
- Upcoming bookings shown first
- Can switch to "Past" tab
- Each booking shows: venue, date, time, court, QR code
- Can tap to view full details
- Shows booking status (confirmed / checked-in / completed / cancelled)

---

### US-P010: Cancel Booking (P0)
**As a** player  
**I want to** cancel a booking if my plans change  
**So that** I can get a refund (if eligible)

**Acceptance Criteria:**
- "Cancel" button visible on booking details
- Shows cancellation policy and refund amount
- Requires confirmation ("Are you sure?")
- Refund processed automatically (if within policy)
- Cancellation confirmation email sent
- Refund notification sent when processed

---

### US-P011: Receive Reminders (P0)
**As a** player  
**I want to** receive reminders before my booking  
**So that** I don't forget or miss my slot

**Acceptance Criteria:**
- SMS reminder sent 24 hours before
- Push notification (if app installed) 2 hours before
- Email reminder 24 hours before (optional)
- Reminder includes venue address and QR code

---

### US-P012: Check-in at Venue (P0)
**As a** player  
**I want to** show my QR code for check-in  
**So that** the venue can verify my booking

**Acceptance Criteria:**
- QR code accessible from "My Bookings"
- QR code works offline (stored locally)
- Venue can scan to confirm booking
- Booking status updates to "checked-in" after scan

---

## Epic 4: Reviews & Ratings

### US-P013: Rate Venue After Visit (P1)
**As a** player  
**I want to** rate the venue after my game  
**So that** I can share my experience with others

**Acceptance Criteria:**
- Prompted to rate 1 day after booking (email + app notification)
- Star rating (1-5)
- Optional written review
- Optional photo upload (up to 5)
- Can rate: court quality, cleanliness, staff, amenities separately

---

### US-P014: Read Reviews (P1)
**As a** player  
**I want to** read reviews from other players  
**So that** I can choose the best venue

**Acceptance Criteria:**
- Reviews shown on venue detail page
- Can sort by: most recent, highest rated, lowest rated
- Can filter by star rating
- Can see reviewer name, photo, and date
- Can mark reviews as "helpful" (thumbs up)

---

## Epic 5: Community Features

### US-P015: Post "Looking for Player" (P1)
**As a** player  
**I want to** post that I need a playing partner  
**So that** I can find someone to play with

**Acceptance Criteria:**
- Can create post with: sport, venue, date, time, skill level, slots needed
- Optional message
- Post visible to all users (or filtered by location)
- Can edit/delete post
- Receives notifications when someone applies

---

### US-P016: Browse "Looking for Player" Posts (P1)
**As a** player  
**I want to** browse posts from others looking for partners  
**So that** I can join a game

**Acceptance Criteria:**
- Can filter by: sport, date, location, skill level
- Can see poster's profile (name, photo, skill, games played)
- Can apply to join (sends message to poster)
- Can message poster directly

---

### US-P017: Build Player Profile (P1)
**As a** player  
**I want to** create a profile with my skill level and preferences  
**So that** others can find me for games

**Acceptance Criteria:**
- Can upload profile photo
- Can set skill level (beginner, intermediate, advanced)
- Can list preferred sports
- Can write bio (optional)
- Can set availability (recurring schedule)
- Public profile visible to other players

---

### US-P018: Group Booking (P1)
**As a** player  
**I want to** invite friends to split a booking  
**So that** we can share the cost

**Acceptance Criteria:**
- Can invite up to 3 friends (via email or phone)
- Each person pays their share
- Booking confirmed once all payments received (or 24h timeout)
- Can set equal split or custom amounts
- Group members can chat about the booking

---

## Epic 6: Advanced Features

### US-P019: Join Digital Queue (P2)
**As a** player  
**I want to** join a waitlist for walk-in availability  
**So that** I can play if a slot opens up

**Acceptance Criteria:**
- Can join queue for a venue + time window
- See position in queue (real-time updates)
- Receive SMS when slot available (15-min window to book)
- Can leave queue anytime
- Auto-removed if don't respond in 15 min

---

### US-P020: Track Performance Stats (P2)
**As a** player  
**I want to** log my game results and track stats  
**So that** I can see my improvement over time

**Acceptance Criteria:**
- Can log game results (win/loss/score)
- Can tag opponents (if registered)
- Dashboard shows: total games, win rate, favorite venue
- Skill rating calculated (ELO-style)
- Can share stats on social media

---

### US-P021: Find AI-Matched Opponents (P2)
**As a** player  
**I want to** receive AI-powered opponent suggestions  
**So that** I can play with people at my skill level

**Acceptance Criteria:**
- AI suggests players based on: skill, location, schedule, playing style
- Can view suggested player's profile
- Can send challenge invitation
- Receives notification when matched player accepts

---

# Venue Owner Persona Stories

## Epic 7: Venue Onboarding

### US-V001: Create Venue Account (P0)
**As a** venue owner  
**I want to** sign up and create my venue profile  
**So that** I can start accepting bookings

**Acceptance Criteria:**
- Can sign up with business email
- Email verification required
- Can enter venue details: name, address, phone, website
- Can upload venue photos (minimum 3)
- Can describe amenities (checkboxes)
- Terms of service acceptance

---

### US-V002: Configure Courts (P0)
**As a** venue owner  
**I want to** add my courts to the system  
**So that** players can book them

**Acceptance Criteria:**
- Can add multiple courts (number or name each)
- Can set court type (badminton, pickleball, multi-use)
- Can set operating hours (per day of week)
- Can set pricing (per hour or custom time blocks)
- Can set court-specific rules (e.g., "Court 1: tournaments only on weekends")

---

### US-V003: Set Pricing & Policies (P0)
**As a** venue owner  
**I want to** configure my pricing and cancellation policies  
**So that** I control my revenue rules

**Acceptance Criteria:**
- Can set base price per hour (per court or venue-wide)
- Can set peak/off-peak pricing (different rates by time)
- Can set cancellation policy: refund % based on hours before booking
- Can set minimum booking duration (30 min, 1 hour, etc.)
- Can set advance booking window (e.g., max 7 days ahead)

---

## Epic 8: Calendar & Booking Management

### US-V004: View Booking Calendar (P0)
**As a** venue owner  
**I want to** see all bookings in a calendar view  
**So that** I can manage my schedule at a glance

**Acceptance Criteria:**
- Multi-court calendar (rows = courts, columns = time)
- Can switch between day/week/month view
- Bookings color-coded by status (confirmed, checked-in, completed, cancelled)
- Can click booking to see details
- Real-time updates (no refresh needed)

---

### US-V005: Manually Create Booking (P0)
**As a** venue owner  
**I want to** manually create bookings for walk-ins or phone reservations  
**So that** my calendar reflects all bookings (not just online)

**Acceptance Criteria:**
- Can select court + time slot from calendar
- Can enter customer name, phone, email (optional)
- Can choose payment method (cash, online, paid via call)
- Booking marked as "staff-created"
- Can send confirmation SMS to customer (optional)

---

### US-V006: Block/Unblock Slots (P0)
**As a** venue owner  
**I want to** block time slots for maintenance or private events  
**So that** players can't book during those times

**Acceptance Criteria:**
- Can select one or multiple slots
- Can mark as "blocked" with optional reason
- Blocked slots show as unavailable to players
- Can set recurring blocks (e.g., "every Monday 9-11am")
- Can unblock anytime

---

### US-V007: Check-in Players (P0)
**As a** venue owner  
**I want to** scan player QR codes to confirm check-in  
**So that** I verify bookings and prevent fraud

**Acceptance Criteria:**
- Can scan QR code via tablet/phone camera
- Booking details displayed instantly
- One-tap "Check-in" button
- Invalid/expired QR shows error message
- Checked-in bookings marked in calendar

---

### US-V008: Handle Cancellations (P0)
**As a** venue owner  
**I want to** view and manage cancellation requests  
**So that** I can handle refunds and free up slots

**Acceptance Criteria:**
- Notifications for cancellations
- Can approve/deny cancellation (if outside policy)
- Refunds processed automatically (if policy allows)
- Cancelled slot becomes available instantly
- Can see cancellation rate in analytics

---

## Epic 9: Financials & Payouts

### US-V009: View Earnings Dashboard (P0)
**As a** venue owner  
**I want to** see my earnings in real-time  
**So that** I can track revenue

**Acceptance Criteria:**
- Dashboard shows: today's earnings, this week, this month
- Shows pending payouts vs. already paid
- Breakdown by court
- Shows platform fee deducted
- Can download transaction history (CSV)

---

### US-V010: Receive Payouts (P0)
**As a** venue owner  
**I want to** receive my earnings to my bank account  
**So that** I get paid for bookings

**Acceptance Criteria:**
- Payouts processed weekly (every Monday)
- Email notification when payout initiated
- Shows payout breakdown (gross - fees = net)
- Can set bank account details (verified via micro-deposit)
- Can view payout history

---

## Epic 10: Marketing & Customer Management

### US-V011: Create Promo Codes (P1)
**As a** venue owner  
**I want to** create promotional discounts  
**So that** I can attract more bookings during slow times

**Acceptance Criteria:**
- Can create code (custom text)
- Can set discount (% or fixed amount)
- Can set validity period (start/end date)
- Can set usage limit (total uses or per-user)
- Can set restrictions (e.g., off-peak only, new users only)
- Can see promo code performance (uses, revenue impact)

---

### US-V012: View Customer List (P1)
**As a** venue owner  
**I want to** see who has booked my venue  
**So that** I can build customer relationships

**Acceptance Criteria:**
- List of all customers (name, phone, email)
- Shows total bookings per customer
- Shows last booking date
- Can filter by: repeat customers, VIPs, first-timers
- Can export list (CSV)

---

### US-V013: Send Marketing Emails (P1)
**As a** venue owner  
**I want to** send promotional emails to my customers  
**So that** I can drive repeat bookings

**Acceptance Criteria:**
- Can select audience (all, repeat customers, inactive >30 days)
- Can write subject + message (rich text editor)
- Can attach promo code
- Can schedule send time
- Can see open rate and click rate

---

## Epic 11: Analytics & Insights

### US-V014: View Utilization Report (P0)
**As a** venue owner  
**I want to** see my court utilization rate  
**So that** I know how efficiently I'm operating

**Acceptance Criteria:**
- Shows % of slots booked (per court, per venue)
- Breakdown by: day of week, time of day
- Compares to previous week/month
- Highlights underutilized time slots
- Suggests optimal pricing (AI-driven)

---

### US-V015: View Customer Behavior Analytics (P1)
**As a** venue owner  
**I want to** understand my customers' booking patterns  
**So that** I can optimize operations

**Acceptance Criteria:**
- Shows: peak hours, popular courts, average booking duration
- Shows customer demographics (age, location)
- Shows repeat rate (% customers who book 2+ times)
- Shows no-show rate and cancellation rate
- Shows average revenue per customer

---

### US-V016: Compare Performance (P1)
**As a** venue owner  
**I want to** compare my venue's performance to market benchmarks  
**So that** I know if I'm competitive

**Acceptance Criteria:**
- Shows: my rating vs. city average
- Shows: my pricing vs. similar venues
- Shows: my utilization vs. city average
- Anonymized data (doesn't reveal competitor names)

---

## Epic 12: Advanced Venue Features

### US-V017: Manage Equipment Rentals (P2)
**As a** venue owner  
**I want to** offer equipment rentals (rackets, shoes)  
**So that** I can earn additional revenue

**Acceptance Criteria:**
- Can add inventory items (name, price, quantity)
- Players can add rentals to booking
- Rental availability tracked in real-time
- Can set damage fees
- Can track rental history (which items, to whom)

---

### US-V018: Create Tournaments (P2)
**As a** venue owner  
**I want to** host tournaments and manage registrations  
**So that** I can attract more players

**Acceptance Criteria:**
- Can create tournament (name, date, format, entry fee)
- Players can register via platform
- Auto-generates brackets (single/double elimination)
- Can enter match results
- Winners announced and notified

---

### US-V019: Offer Membership Plans (P2)
**As a** venue owner  
**I want to** sell monthly membership plans  
**So that** I can secure recurring revenue

**Acceptance Criteria:**
- Can create plans (e.g., "Unlimited off-peak" for ₱3,000/mo)
- Players can subscribe via platform
- Auto-renewal monthly
- Can set plan benefits (priority booking, discounts)
- Can track active memberships and MRR (monthly recurring revenue)

---

### US-V020: Manage Staff Accounts (P2)
**As a** venue owner  
**I want to** give my staff access to the dashboard  
**So that** they can manage bookings without my login

**Acceptance Criteria:**
- Can create staff accounts (email invitation)
- Can set roles: admin, manager, front desk
- Permissions: admin (full access), manager (bookings + analytics), front desk (check-in only)
- Can disable/remove staff accounts
- Audit log shows who did what

---

## Story Summary by Priority

### P0 (MVP - 27 stories)
- Player: 12 stories (discovery, booking, payment, management, check-in)
- Venue: 15 stories (onboarding, calendar, check-in, payouts, basic analytics)

### P1 (Standard - 15 stories)
- Player: 6 stories (reviews, find-a-player, profile, group booking)
- Venue: 9 stories (promo codes, customer mgmt, marketing, advanced analytics)

### P2 (Full-Featured - 8 stories)
- Player: 3 stories (digital queue, performance tracking, AI matching)
- Venue: 5 stories (equipment, tournaments, memberships, staff mgmt)

**Total:** 50 user stories across all priorities

---

## Story Mapping (Development Sprints)

### Sprint 1-2 (Weeks 1-4): Core Booking
- US-P001, US-P002, US-P003, US-P004, US-P005 (Discovery & availability)
- US-V001, US-V002, US-V003 (Venue onboarding)

### Sprint 3-4 (Weeks 5-8): Payment & Confirmation
- US-P006, US-P007, US-P008 (Account, payment, confirmation)
- US-V004, US-V005, US-V006, US-V007 (Calendar & check-in)

### Sprint 5-6 (Weeks 9-12): Management & Analytics
- US-P009, US-P010, US-P011, US-P012 (Player booking management)
- US-V009, US-V010, US-V014 (Venue financials & analytics)

### Sprint 7-8 (Weeks 13-16): Community Features
- US-P013, US-P014, US-P015, US-P016, US-P017, US-P018 (Reviews, find-a-player, groups)
- US-V011, US-V012, US-V013, US-V015, US-V016 (Marketing & customer insights)

### Sprint 9-10 (Weeks 17-20): Advanced Features
- US-P019, US-P020, US-P021 (Queue, stats, AI matching)
- US-V017, US-V018, US-V019, US-V020 (Equipment, tournaments, memberships, staff)

---

**Document Owner:** Discovery Agent  
**Last Updated:** 2026-02-10  
**Status:** Ready for design phase
